# Having trouble using Backpack?

No documentation can be 100% complete and Backpack's is no different, sorry for that. There are plenty of people that follow [the StackOverflow tag "backpack-for-laravel"](https://stackoverflow.com/questions/tagged/backpack-for-laravel) and are glad to help you out. Post your question there and please include:
- (A) what you did
- (B) what you expected to happen
- (C) what happened
- (D) what have you already tried to fix it?

# Idea for a new feature?

**[Open an issue](https://github.com/laravel-backpack/crud) and tell the community you are willing to submit a PR.** We usually end up with better solutions when we talk about it and everybody pitches in with their opinion. Plus, some features might be better presented as a separate package, a tutorial or a code snippet.

PR Rules:

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **[PSR-2 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - The easiest way to apply the conventions is to install [PHP Code Sniffer](http://pear.php.net/package/PHP_CodeSniffer). It's ok to push non-PSR-2 code, but know that [StyleCI](https://styleci.io/) will convert it after the merge. 

# Discovered a bug?

**Step 1. [Open an issue](https://github.com/laravel-backpack/crud).** Please include:
- (A) what you did
- (B) what you expected to happen
- (C) what happened
- (D) what have you already tried to fix it?

**Step 2. Submit a PR.** 
If you have a solution for it and want to help, you can submit a Pull Request. Tell us you are willing to do that. It takes a little more time from you, but:
- your fix is guaranteed to be merged a lot faster;
- you'll become one of the Backpack contributors; [welcome to the party! :-)](https://media.giphy.com/media/l0MYt5jPR6QX5pnqM/giphy.gif);
- you'll not just be helping yourself and the maintainers of Backpack, you'd be helping thousands of Backpack developers;

If you've never submitted a PR before, don't worry, it's not that difficult. Read [this tutorial](https://mattstauffer.com/blog/how-to-contribute-to-an-open-source-github-project-using-your-own-fork) and the rules above. I promise, you'll enjoy sending PRs after a while :-)


# Want to help out?

Thank you, thank you, thank you! You can:
- [add a StackOverflow filter](https://stackexchange.com/filters) to receive emails for backpack-for-laravel questions;
- [install Gitter](https://gitter.im/BackpackForLaravel/Lobby) and help people out in real-time;
- [star Backpack\CRUD on GitHub](https://github.com/laravel-backpack/crud) so the repository can get more views;
- [purchase a commercial license](https://www.backpackforlaravel.com/commercial-license/form), if you use Backpack to make money;
- ALL OF THE ABOVE. Groundbreaking, I know, right? :-)

# How to do those things

### Pull Requests
- There are no restrictions. Go ahead and submit your PR!

### Issues
- There are no restrictions. Go ahead and submit your issue!

### Rules for writing effectively

This project stands by [The Whole Fruit Manifesto](https://github.com/the-whole-fruit/manifesto). We believe that “_writing good code_” is not only about “_writing good code_”. It’s also about the words around it. That’s why, to make sure your contribution is well received, we ask you to [read and keep in mind the ONE=MOR framework and guidelines](https://github.com/the-whole-fruit/manifesto) when writing comment blocks, PR titles, PR descriptions, and in general, when writing to our community.


Thank you for contributing. 
**Happy coding**!
